/*==============================================================================
*  Labor market series for Spain
*=============================================================================*/
clear all
set more off

cd "$insheet_files/Spain"

*===============================================================================
* I. Labor force stats from the Spanish stat office, 1976-2004
*===============================================================================
import excel using "ES STAT 1976-2004 Q.xls", first clear /// 
	cellrange(C6:DQ214) sheet("processed") 

drop if nuts==""

reshape long year_, i(nuts region variable) j(quarter)

gen year = int(quarter/10)

collapse (mean) year_, by(variable year region_name nuts)

replace variable = "LF" if variable=="Labor force"
replace variable = "EMP" if variable=="Employed"
replace variable = "UNEMP" if variable=="Unemployed"

reshape wide year_, i(nuts region year) j(variable) string

rename year_LF	  LF_STAT_ES
rename year_EMP   EMP_STAT_ES
rename year_UNEMP UNEMP_STAT_ES

tempfile  nuts3
save 	 `nuts3.dta'

gen nuts2 = substr(nuts,1,4)

collapse (sum) LF EMP UNEMP, by(nuts2 year)

rename nuts2 nuts
tempfile  nuts2
save 	 `nuts2.dta'

gen nuts1 = substr(nuts,1,3)

collapse (sum) LF EMP UNEMP, by(nuts1 year)

rename nuts1 nuts
tempfile  nuts1
save 	 `nuts1.dta'

collapse (sum) LF EMP UNEMP, by(year)

gen nuts="ES"

append using `nuts1.dta'
append using `nuts2.dta'
append using `nuts3.dta'

label var LF_STAT_ES "Labor Force, ES Statistical Office"
label var EMP_STAT_ES "Employed, ES Statistical Office"
label var UNEMP_STAT_ES "Unemployed, ES Statistical Office"

tempfile ES_labor_1974_2004
save `ES_labor_1974_2004.dta'

*===============================================================================
* 							II.	Total Population 
*===============================================================================
clear
import excel "Spanish Stat Office, Total POP, pcaxis-431479951.xls", first ///
	cellrange(A2:AR20) sheet("POP Processed")

reshape long y, i(nuts region_name) j(year)
rename y POP_STAT_ES

tempfile pop_nuts2
save `pop_nuts2.dta'

gen nuts1= substr(nuts,1,3)

collapse (sum) POP, by(nuts1 year)

rename nuts1 nuts

tempfile pop_nuts1
save `pop_nuts1.dta'

gen country=substr(nuts,1,2)

collapse (sum) POP, by(country year)

rename country nuts

append using `pop_nuts1.dta'
append using `pop_nuts2.dta'

replace POP = POP/1000

label var POP "Total Population, ES Statistical Office

tempfile ES_POP_1970_2012_processed
save `ES_POP_1970_2012_processed.dta'

*===============================================================================
* 								III. 1970 Census
*===============================================================================
import excel "ES_CENS_1970.xlsx", first clear

tempfile  nuts3
save 	 `nuts3.dta'

gen nuts2 = substr(nuts,1,4)

collapse (sum) POP LF UNEMP, by(nuts2)

rename nuts2 nuts
tempfile  nuts2
save 	 `nuts2.dta'

gen nuts1 = substr(nuts,1,3)

collapse (sum) POP LF UNEMP, by(nuts1)

rename nuts1 nuts
tempfile  nuts1
save 	 `nuts1.dta'

collapse (sum) POP LF UNEMP

gen nuts="ES"

append using `nuts1.dta'
append using `nuts2.dta'
append using `nuts3.dta'

foreach var of varlist POP UNEMP LF {
	replace `var' = `var'/1000
}

rename 	POP 	POP_CENS_ES
rename 	LF	LF_CENS_ES
rename 	UNEMP	UNEMP_CENS_ES

gen 	EMP_CENS_ES	=	LF_CENS_ES-UNEMP_CENS_ES

label var POP_CENS_ES "Total population, ES Census 1970"
label var LF_CENS_ES "Labor force, ES Census 1970"
label var EMP_CENS_ES "Employed, ES Census 1970"
label var UNEMP_CENS_ES "Unemployed, ES Census 1970"

gen year=1970

merge 1:1 nuts year using `ES_labor_1974_2004.dta', nogen 
merge 1:1 nuts year using `ES_POP_1970_2012_processed.dta', nogen 

order nuts region_name year POP* LF* EMP* UNEMP* 
sort nuts year
save "$dta_files/ES_labor.dta", replace
